/*
 * authusekey - decode a key from ascii and use it
 */
#include <config.h>
#include <stdio.h>
#include <ctype.h>

#include "ntp_types.h"
#include "ntp_string.h"
#include "ntp_stdlib.h"

/*
 * Only used by ntp{q,dc} to set the key/algo/secret triple to use.
 * Uses the same decoding scheme ntpd uses for keys in the key file.
 */
bool
authusekey(
	keyid_t keyno,
	int keytype,
	const u_char *str
	)
{
	size_t	len;
	u_char	buf[AUTHPWD_MAXSECLEN];

	len = authdecodepw(buf, sizeof(buf), (const char *)str, 
			   AUTHPWD_UNSPEC);
	if (len < 1 || len > sizeof(buf)) {
		return FALSE;
	}
	MD5auth_setkey(keyno, keytype, buf, len, NULL);
	/* clear out decoded password from stack */
	ZERO(buf);

	return TRUE;
}
