/*
 * atomic/gcc_generic.h - atomic operations for GCC compiler
 *
 * Written by Juergen Perlinger (perlinger@ntp.org) for the NTP project.
 * The contents of 'html/copyright.html' apply.
 *
 * ----------------------------------------------------------------------
 *
 * These versions uses GCC builtins
 */
#ifndef ATOMIC_GCC_GENERIC_H
#define ATOMIC_GCC_GENERIC_H

static inline uint32_t atomic_inc(
	volatile uint32_t *dst)
{
	return __sync_add_and_fetch(dst, 1);
}

static inline uint32_t atomic_set(
	volatile uint32_t *dst,
	uint32_t           val)
{
	/* need a full lock, so we loop around the CAS function */
	uint32_t old;
	do
		old = *dst;
	while (old != __sync_val_compare_and_swap(dst, old, val));
	return old;
}

static inline uint32_t atomic_cas(
	volatile uint32_t *dst,
	uint32_t           val,
	uint32_t           cmp)
{
	return __sync_val_compare_and_swap(dst, cmp, val);
}

static inline void atomic_barrier(void)
{
	__sync_synchronize();
}

#endif /* !defined(ATOMIC_GCC_GENERIC_H) */
