/*
 * atomic/msvc8.h - atomic operations for VisualStudio 2005 and later
 *
 * Written by Juergen Perlinger (perlinger@ntp.org) for the NTP project.
 * The contents of 'html/copyright.html' apply.
 *
 * ----------------------------------------------------------------------
 *
 * These versions uses VisualC interlocked intrinsics
 */
#ifndef ATOMIC_MSVC8_H
#define ATOMIC_MSVC8_H

# include <intrin.h>
#pragma intrinsic(_InterlockedCompareExchange)
#pragma intrinsic(_InterlockedExchange)
#pragma intrinsic(_InterlockedIncrement)

static __inline uint32_t atomic_inc(
	volatile uint32_t *dst)
{
	return _InterlockedIncrement((volatile long*)dst);
}

static __inline uint32_t atomic_set(
	volatile uint32_t *dst,
	uint32_t           val)
{
	return _InterlockedExchange((volatile long*)dst, val);
}

static __inline uint32_t atomic_cas(
	volatile uint32_t *dst,
	uint32_t           val,
	uint32_t           cmp)
{
	return _InterlockedCompareExchange((volatile long*)dst, val, cmp);
}

static __inline void atomic_barrier(void)
{
	/* that's a nasty trick here... Exchange a dummy just for barrier effect*/
	volatile long dummy;
	_InterlockedExchange(&dummy, ~dummy);
}

#endif /* !defined(ATOMIC_MSVC8_H) */
