/*
 * stdint_ntp.h - stdint conforming declarations, based on 'config.h'
 *
 * Written by Juergen Perlinger (perlinger@ntp.org) for the NTP project.
 * The contents of 'html/copyright.html' apply.
 *
 * ---------------------------------------------------------------------
 *
 * Having a compiler-dependent memory layout in shared memory would be
 * a mess. It's definitely worth nailing things down, but that needs types
 * with well-defined size.
 *
 * On most systems there should be a 'stdint.h' header. This is not true
 * for VisualStudio until at least MSVS2008, but a compatible header is
 * provided for the NTP project. But if everything else fails, we can use
 * the contents of config.h to create the handful of bare-bone types needed
 * for well-defined atomic ops and shared memory access.
 *
 */
#ifndef STDINT_NTP_H
#define STDINT_NTP_H

#include "config.h"

#if SIZEOF_SIGNED_CHAR == 1
typedef   signed char  int8_t;
typedef unsigned char uint8_t;
#else
# error cannot typedef (u)int8_t
#endif

#if SIZEOF_SHORT == 2
typedef   signed short int16_t;
typedef unsigned short uint16_t;
#elif SIZEOF_INT == 2
typedef   signed int int16_t;
typedef unsigned int uint16_t;
#else
# error cannot typedef (u)int16_t
#endif

#if SIZEOF_INT == 4
typedef   signed int  int32_t;
typedef unsigned int uint32_t;
#elif SIZEOF_LONG == 4
typedef   signed long  int32_t;
typedef unsigned long uint32_t;
#else
# error cannot typedef (u)int32_t
#endif

#if SIZEOF_LONG == 8
typedef   signed long  int64_t;
typedef unsigned long uint64_t;
#elif SIZEOF_LONG_LONG == 8
typedef   signed long long  int64_t;
typedef unsigned long long uint64_t;
#else
# error cannot typedef (u)int64_t
#endif


#endif /* !defined(STDINT_NTP_H) */

