/*
 * internal.h -- iternal definitions for libshmclk
 *
 * Written by Juergen Perlinger (perlinger@ntp.org) for the NTP project.
 * The contents of 'html/copyright.html' apply.
 *
 * ----------------------------------------------------------------------
 */
#ifndef INTERNAL_H
#define INTERNAL_H

#include <config.h>

/* get the system specific stuff first -- depends also on SHM model */
#ifdef _MSC_VER
# define WIN32_LEAN_AND_MEAN
# include <windows.h>
# include "stdint_msvc.h"
#else
# include <unistd.h>
# include <sys/times.h>
# ifdef HAVE_SHM_OPEN
#  include <sys/fcntl.h>
#  include <sys/mman.h>
#  include <sys/stat.h>
# else
#  include <sys/shm.h>
# endif
# if defined(HAVE_STDINT_H)
#  include <stdint.h>
# else
#  include "stdint_ntp.h"
# endif
#endif

/* get things we should find everywhere */
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <string.h>
#include <sys/time.h>

#include "shmclockdef.h"


/* forward declarations */
struct timespec;
struct timeval;
struct shmclk_llfp_t;

struct ntp_shmdata_dsc {
    /* SHM segment descriptor first */
    shmclk_sys_t dsc;

    /* type1 specific live detection values */
    uint32_t live_tick;
    uint32_t live_time;
};
typedef struct ntp_shmdata_dsc * ntp_shmdata_dsc_t;

/* we use a table of function pointers to implement the low-level access stuff */
struct shmHandlers {
    int  (*attach )(ntp_shmdata_dsc_t, int);
    void (*detach )(ntp_shmdata_dsc_t);
    int  (*pushttv)(ntp_shmdata_dsc_t, const struct timeval*, const struct timeval*);
    int  (*pushtts)(ntp_shmdata_dsc_t, const struct timespec*, const struct timespec*);
    int  (*pushtfp)(ntp_shmdata_dsc_t, const struct shmclk_llfp_t*, const struct shmclk_llfp_t*);
    int  (*pushaux)(ntp_shmdata_dsc_t, int, int, int*);
    int  (*alive  )(ntp_shmdata_dsc_t);
};

/* a clock descriptor has the data and the function table */
struct ntp_shmclk_dsc {
    const struct shmHandlers * handlers;
    struct ntp_shmdata_dsc     shmdesc;
};
    

/* prototypes & external symbols */

extern size_t lsmc_getShmTime(shmclk_sys_t * dsc, int mode, int unit);
extern void   lsmc_delShmTime(shmclk_sys_t * dsc);

extern const struct shmHandlers lsmc_t0_handlers;
extern const struct shmHandlers lsmc_t1_handlers;

#endif
