#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <signal.h>
#include <time.h>

#ifdef _MSC_VER
# include "stdint_msvc.h"
#else
# include <unistd.h>
# include <stdint.h>
# include <sys/shm.h>
# include <sys/times.h>
#endif

#include "internal.h"
#include "ntp_atomic.h"

/*
 * =====================================================================
 * test app
 * =====================================================================
 */

static int    doloop = 1;
static ntp_shmclk_handle myclock = NULL;

static void cleanup(void)
{
    if (myclock != NULL) {
	printf("cleanup working\n");
	ntp_shmclk_close(myclock);
    }
}

static void handleSigInt(int signo)
{
    doloop = 0;
}

int main(int argc, char **argv)
{
	struct timespec systime, reftime;

	atexit(cleanup);
	signal(SIGINT, handleSigInt);
	
	while (doloop) {
		if (!(myclock && ntp_shmclk_alive(myclock))) {
			ntp_shmclk_close(myclock);
			myclock = ntp_shmclk_open(2, 1);
			if (myclock)
				printf("attched!\n");
		} else {
			fputc('.', stdout);
			fflush(stdout);
			clock_gettime(CLOCK_REALTIME, &systime);
			reftime = systime;
			reftime.tv_nsec -= reftime.tv_nsec % 10000;
			ntp_shmclk_sample_ts(myclock, &reftime, &systime, 0);
		}
		
		usleep(500000);
	}
	fputc('\n', stdout);
	ntp_shmclk_close(myclock);
	myclock = NULL;
	return 0;
}

