
#ifndef __STDINT_INCLUDED
#define __STDINT_INCLUDED

#ifndef _MSC_VER
# error This is MSC specific!
#endif

/*
** The following two macros use MSC specific syntax to define numerical
** constants of a given size and signedness.
*/

#define __INTN_C(c,w)	(c ## i ## w)
#define __UINTN_C(c,w)	(c ## ui ## w)

#define __INT8_MIN	 __INTN_C(0x80,8)
#define __INT8_MAX	 __INTN_C(0x7F,8)
#define __UINT8_MAX	__UINTN_C(0xFF,8)

#define __INT16_MIN	 __INTN_C(0x8000,16)
#define __INT16_MAX	 __INTN_C(0x7FFF,16)
#define __UINT16_MAX	__UINTN_C(0xFFFF,8)

#define __INT32_MIN	 __INTN_C(0x80000000,32)
#define __INT32_MAX	 __INTN_C(0x7FFFFFFF,32)
#define __UINT32_MAX	__UINTN_C(0xFFFFFFFF,32)

#define __INT64_MIN	 __INTN_C(0x8000000000000000,64)
#define __INT64_MAX	 __INTN_C(0x7FFFFFFFFFFFFFFF,64)
#define __UINT64_MAX	__UINTN_C(0xFFFFFFFFFFFFFFFF,64)


/*
** Exact width integer types
*/

typedef	__int8	int8_t;
typedef	__int16	int16_t;
typedef	__int32	int32_t;
typedef	__int64	int64_t;

#ifndef INT8_MIN
#define INT8_MIN __INT8_MIN
#endif
#ifndef INT16_MIN
#define INT16_MIN __INT16_MIN
#endif
#ifndef INT32_MIN
#define INT32_MIN __INT32_MIN
#endif
#ifndef INT64_MIN
#define INT64_MIN __INT64_MIN
#endif

#ifndef INT8_MAX
#define INT8_MAX __INT8_MAX
#endif
#ifndef INT16_MAX
#define INT16_MAX __INT16_MAX
#endif
#ifndef INT32_MAX
#define INT32_MAX __INT32_MAX
#endif
#ifndef INT64_MAX
#define INT64_MAX __INT64_MIN
#endif

typedef unsigned __int8  uint8_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int64 uint64_t;

#ifndef UINT8_MAX
#define UINT8_MAX __UINT8_MAX
#endif
#ifndef UINT16_MAX
#define UINT16_MAX __UINT16_MAX
#endif
#ifndef UINT32_MAX
#define UINT32_MAX __UINT32_MAX
#endif
#ifndef UINT64_MAX
#define UINT64_MAX __UINT64_MIN
#endif

/*
** Least-size integers
**
** These are mapped to exact size.
*/

typedef	__int8	int_least8_t;
typedef	__int16	int_least16_t;
typedef	__int32	int_least32_t;
typedef	__int64	int_least64_t;

#define INT_LEAST8_MIN	__INT8_MIN
#define INT_LEAST16_MIN	__INT16_MIN
#define INT_LEAST32_MIN	__INT32_MIN
#define INT_LEAST64_MIN	__INT64_MIN

#define INT_LEAST8_MAX	__INT8_MAX
#define INT_LEAST16_MAX	__INT16_MAX
#define INT_LEAST32_MAX	__INT32_MAX
#define INT_LEAST64_MAX	__INT64_MAX


typedef unsigned  __int8 uint_least8_t;
typedef unsigned __int16 uint_least16_t;
typedef unsigned __int32 uint_least32_t;
typedef unsigned __int64 uint_least64_t;

#define UINT_LEAST8_MAX  __UINT8_MAX
#define UINT_LEAST16_MAX __UINT16_MAX
#define UINT_LEAST32_MAX __UINT32_MAX
#define UINT_LEAST64_MAX __UINT64_MAX

/*
** least-size, fastest integer
**
** The 'FAST' types are all 32 bits, except the 64 bit quantity; as the
** natural register width is 32 bits, quantities of that size are fastest
** to operate on naturally. (This even holds for the x86_64; MSVC uses
** the 'llp64' model.
*/

typedef	__int32	int_fast8_t;
typedef	__int32	int_fast16_t;
typedef	__int32	int_fast32_t;
typedef	__int64	int_fast64_t;

#define INT_FAST8_MIN  __INT32_MIN
#define INT_FAST16_MIN __INT32_MIN
#define INT_FAST32_MIN __INT32_MIN
#define INT_FAST64_MIN __INT64_MIN

#define INT_FAST8_MAX  __INT32_MAX
#define INT_FAST16_MAX __INT32_MAX
#define INT_FAST32_MAX __INT32_MAX
#define INT_FAST64_MAX __INT64_MAX


typedef unsigned __int32 uint_fast8_t;
typedef unsigned __int32 uint_fast16_t;
typedef unsigned __int32 uint_fast32_t;
typedef unsigned __int64 uint_fast64_t;

#define UINT_FAST8_MAX	__UINT32_MAX
#define UINT_FAST16_MAX	__UINT32_MAX
#define UINT_FAST32_MAX	__UINT32_MAX
#define UINT_FAST64_MAX	__UINT64_MAX


/*
** The (u)intptr_t, ptrdiff_t and size_t definitions depend on the
** target: 32bit for x86, and 64bit for x64, aka amd64. Well, we
** have to bite the bullet.
*/

/* ------------------------------------------------------------------ */
# if defined(_WIN64) || defined(WIN64)
/* ------------------------------------------------------------------ */

# ifndef _INTPTR_T_DEFINED
#  define _INTPTR_T_DEFINED
   typedef __int64 intptr_t;
# endif

# ifndef INTPTR_MIN
#  define INTPTR_MIN __INT64_MIN
# endif

# ifndef INTPTR_MAX
#  define INTPTR_MAX __INT64_MAX
# endif

# ifndef _UINTPTR_T_DEFINED
#  define _UINTPTR_T_DEFINED
   typedef unsigned __int64 uintptr_t;
# endif

# ifndef UINTPTR_MAX
#  define UINTPTR_MAX __UINT64_MAX
# endif

# ifndef _PTRDIFF_T_DEFINED
#  define _PTRDIFF_T_DEFINED
   typedef __int64 ptrdiff_t;
# endif

# ifndef PTRDIFF_MIN
#  define PTRDIFF_MIN __INT64_MIN
# endif

# ifndef PTRDIFF_MAX
#  define PTRDIFF_MAX __INT64_MAX
# endif

/* ------------------------------------------------------------------ */
#else   /* 32 bit target assumed here! */
/* ------------------------------------------------------------------ */

# ifndef _INTPTR_T_DEFINED
#  define _INTPTR_T_DEFINED
   typedef __int32 intptr_t;
# endif

# ifndef INTPTR_MIN
#  define INTPTR_MIN __INT32_MIN
# endif

# ifndef INTPTR_MAX
#  define INTPTR_MAX __INT32_MAX
# endif

# ifndef _UINTPTR_T_DEFINED
#  define _UINTPTR_T_DEFINED
   typedef unsigned __int32 uintptr_t;
# endif

# ifndef UINTPTR_MAX
#  define UINTPTR_MAX __UINT32_MAX
# endif

# ifndef _PTRDIFF_T_DEFINED
#  define _PTRDIFF_T_DEFINED
   typedef __int64 ptrdiff_t;
# endif

# ifndef PTRDIFF_MIN
#  define PTRDIFF_MIN __INT32_MIN
# endif

# ifndef PTRDIFF_MAX
#  define PTRDIFF_MAX __INT32_MAX
# endif

#endif /* platform dependent stuff */

   
/*
** max integer is 64-bit integer
*/

typedef __int64	intmax_t;
#define INTMAX_MIN __INT64_MIN
#define INTMAX_MAX __INT64_MAX

typedef unsigned __int64 uintmax_t;
#define UINTMAX_MAX __UINT64_MAX


/*
** limit for size_t
*/
#if _MSC_VER <=1200
# if defined(_WIN64) || defined(WIN64)
#  define SIZE_MAX __UINT64_MAX
#else
#  define SIZE_MAX __UINT32_MAX
# endif
#endif

/*
** construct numerical constants of exact the given size and signed-ness
*/

#define INT8_C(c)	__INTN_C(c,8)
#define INT16_C(c)	__INTN_C(c,16)
#define INT32_C(c)	__INTN_C(c,32)
#define INT64_C(c)	__INTN_C(c,64)
#define INTMAX_C(c)	__INTN_C(c,64)

#define UINT8_C(c)	__UINTN_C(c,8)
#define UINT16_C(c)	__UINTN_C(c,16)
#define UINT32_C(c)	__UINTN_C(c,32)
#define UINT64_C(c)	__UINTN_C(c,64)
#define UINTMAX_C(c)	__UINTN_C(c,64)

#endif
/**** EOF ****/
